<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

use App\Models\Competencies; // Import the Eloquent model
use App\Models\Courses; // Import the Eloquent model
use Illuminate\Support\Facades\DB; // Import the DB facade

class CompetenciesController extends Controller
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function index(){
        $competencies = Competencies::all();
        $courses = Courses::all();
        return view('admin/competencies',compact('competencies','courses' ));
    }
    public function addCompetencies() {
        $courses = Courses::all();
        return view('admin/addCompetencies',compact('courses' ));
    }

    public function newCompetencies(Request $request) {
        ini_set('memory_limit', '-1');
        DB::table('competencies')->insert(
            array(
                'name' => $request->name,
        'course' => $request->course,
        'description' => $request->description
            )
       );
   
    return redirect()->route('competencies')->with('success', 'Record updated successfully.');
        
    }

    public function editCompetencies($id){
        $competencies = Competencies::findOrFail($id);
        $courses = Courses::all();
        return view('admin/editCompetencies',compact('competencies','courses'));
    }

    public function updateCompetencies(Request $request)
{
    
    ini_set('memory_limit', '-1');
    Competencies::where('id', $request->input('id'))
    ->update([
        'name' => $request->name,
        'course' => $request->course,
        'description' => $request->description
     ]);
   
    return redirect()->route('competencies')->with('success', 'Record updated successfully.');
}

public function deleteCompetencies($id){
    DB::table('competencies')->where('id', $id)->delete();
    return redirect()->route('competencies')->with('success', 'Record deleted successfully.');
}
}
