<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

use App\Models\Courses; // Import the Eloquent model
use Illuminate\Support\Facades\DB; // Import the DB facade

class CourseController extends Controller
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function index(){
        $courses = Courses::all();
        
        return view('admin/courses',compact('courses'));
    }
    public function addcourse() {
        return view('admin/addcourse');
    }

    public function newcourse(Request $request) {
        ini_set('memory_limit', '-1');
        DB::table('courses')->insert(
            array(
                'name' => $request->name,
                'description' => $request->description
            )
       );
   
    return redirect()->route('course')->with('success', 'Record updated successfully.');
        
    }
    public function editCourse($id){
        $courses = Courses::findOrFail($id);
        
        return view('admin/editCourse',compact('courses'));
    }

    public function updateCourse(Request $request)
{
    
    ini_set('memory_limit', '-1');
    Courses::where('id', $request->input('id'))
    ->update([
        'name' => $request->name,
        'description' => $request->description
     ]);
   
    return redirect()->route('course')->with('success', 'Record updated successfully.');
}

public function deletecourse($id){
    DB::table('courses')->where('id', $id)->delete();
    return redirect()->route('course')->with('success', 'Record deleted successfully.');
}
}
