<?php

// Include database connection file
require_once 'db_connection_dev.php';

// SQL query to fetch data from database


// Create API
    // step 1 get venue id
    // step 2 send venue id to sanpark API
    // step 3 get parent event details
    //step 4  get all parent activities
   //  step 5 customize according to requirement

    if (isset($_GET['park_id']) ) {
        // Retrieve GET parameters
        $park_id = $_GET['park_id'];
        // step1
        $sql = "SELECT parks.venue_id , region.community_id FROM parks LEFT JOIN region ON parks.region_id = region.id WHERE parks.id=$park_id";

        // Execute query
        $result = mysqli_query($conn, $sql);

        // Check if query executed successfully
        if ($result) {
            // Check if there are rows returned
            if (mysqli_num_rows($result) > 0) {
                // Fetch data from result set and output each row
                while ($row = mysqli_fetch_assoc($result)) {
                    $venue_id = $row["venue_id"];
                    $community_id = $row["community_id"];
                }
            } else {
                echo "No park found";
            }
        } else {
            echo "Error: " . mysqli_error($conn);
        }

        
        // Output JSON response
        header('Content-Type: application/json');
       // echo json_encode(array('status' => 'success', 'message' => $result));
    } else {
        // Error handling if parameters are missing
        header('Content-Type: application/json');
        echo json_encode(array('status' => 'error', 'message' => 'Missing parameters'));
    }

    //prepare for API
    $headers = array(
    'Content-Type: application/json', // Example content type
    'Authorization: protel@plankton.mobi:AQAAAAEAACcQAAAAEPGV+1drOoahUh2y/8aIPi6g/VTYw7MXDyShvbnc+PJdMumaYM+vL5PnTbRZ2/U7yw==', // Example authorization header
    );
    // Initialize stream context
    $context = stream_context_create(array(
        'http' => array(
            'method' => 'GET', // Specify the HTTP method (GET, POST, etc.)
            'header' => implode("\r\n", $headers), // Set headers as a single string separated by "\r\n"
        ),
    ));

    $eventActivities = [];
    //step 2 get parent event id 
    $getVenuesURL = 'https://protel.plankton.mobi/api/v2/venues/community/'.urlencode($community_id).'?status='.urlencode('Enabled');
    $data = file_get_contents($getVenuesURL, false, $context);
    $getVenuesURL = json_decode($data, true);
    $parentEvents = [];
    foreach ($getVenuesURL as $venue) {
        // Access each item in the array
        if($venue['VenueId'] == $venue_id){
            //'venue present'
           
            // [EventType] => Parent
            // [EventCatagory] => Entries
            foreach ($venue['Events'] as $event) {
                if($event['EventType'] == "Parent" && $event['EventCatagory'] == "Entries"){
                    array_push($parentEvents, $event['EventId']);
                    // $parent_event_id = $event['EventId'];
                }
            }
        }
         // Example: Print or process each item here
    }
    
    // step 3 get parent event details
    foreach ($parentEvents as $key => $value) {
        
        if($_GET['date_from']){
            $fromDate=$_GET['date_from'];
        }else{
            $fromDate='1990-01-01';
        }

        if($_GET['date_to']){
            $toDate=$_GET['date_to'];
        }else{
            $toDate='2090-01-01';
        }
        
       //step 4  get all parent activities
        $getEventDetails = 'https://protel.plankton.mobi/api/Events/getchildevents?parentId='.urlencode($value).'&fromDate='.urlencode($fromDate).'&toDate='.urlencode($toDate).'&status='.urlencode('open');
        $getEventData = file_get_contents($getEventDetails, false, $context);
        $response = json_decode($getEventData, true);
        foreach ($response as $key => $value) {
            array_push($eventActivities,$value);
        }
        
    }
    //  step 5 customize according to requirement
    $ticketData = [];
    $eventDetails=[];
    foreach ($eventActivities as $key => $activities) {
        
        $getTicketDataUrl = 'https://spaugrabies.plankton.mobi/api/events/'.urlencode($activities["EventId"]).'/tickets?pos=false&fromDate='.urlencode($fromDate).'&status='.urlencode('open');
        $data = file_get_contents($getTicketDataUrl, false, $context);
        $getTicketData = json_decode($data, true);
        //print_r($getTicketData);

        $eventDetails["EventId"] =   $activities['EventId'];
        $eventDetails["Name"] = $activities['Name'];
        $eventDetails["ParentEventId"] = $activities['ParentEventId'];
        $eventDetails["EventType"] = $activities['EventType'];
        $eventDetails["EventDate"] = $activities['EventDate'];
        $eventDetails["Venue"] = $activities['Venue'];
        $eventDetails["Province"] = $activities['Province'];
        $eventDetails["CreatedOn"] = $activities['CreatedOn'];
        $eventDetails["Description"] = $activities['Description'];
        $eventDetails["Status"] = $activities['Status'];
        $eventDetails["VoluntaryRefundFee"] = $activities['VoluntaryRefundFee'];
        $eventDetails["RefundFee"] = $activities['RefundFee'];
        $eventDetails["MaxCapacity"] = $activities['MaxCapacity'];
        $eventDetails["RemainingCapacity"] = $activities['RemainingCapacity'];
        $eventDetails["VenueId"] = $activities['VenueId'];
        $eventDetails["Notes"] =$activities['Notes'];
        $eventDetails["ResortCode"] = $activities['ResortCode'];
        $eventDetails["Timeslots"] =$activities['Timeslots'];
        $eventDetails["ImgHeader"] = $activities['ImgHeader'];
        $eventDetails["ImgSquare"] =$activities['ImgSquare'];
        $eventDetails["ImgePoster"] = $activities['ImgePoster'];
        $eventDetails["ImgThumb"] = $activities['ImgThumb'];
        
        $eventDetails['tickets']=[];
        $ticket = [];
        foreach ($getTicketData as $key1 => $ticketdetails) {
            $ticket['id'] = $park_id;
            $ticket["TicketId"]= $ticketdetails['TicketId'];
            $ticket["Name"]= $ticketdetails['Name'];
            $ticket["Price"]= $ticketdetails['Price'];
            $ticket["MaxPerTransaction"]= $ticketdetails['MaxPerTransaction'];
            $ticket["MinPerTransaction"]= $ticketdetails['MinPerTransaction'];
            $ticket["MaxPerCustomer"]= $ticketdetails['MaxPerCustomer'];
            $ticket["MinPerCustomer"]= $ticketdetails['MinPerCustomer'];
            $ticket["TotalTickets"]= $ticketdetails['TotalTickets'];
            $ticket["Description"]= $ticketdetails['Description'];
            $ticket["LongDescription"]= $ticketdetails['LongDescription'];
            $ticket["AvailableTickets"]= $ticketdetails['AvailableTickets'];
            $ticket["TicketEventId"]= $ticketdetails['TicketEventId'];
            $ticket["TicketEventName"]= $ticketdetails['TicketEventName'];
            $ticket["DisplayOrder"]= $ticketdetails['DisplayOrder'];
            $ticket["TagType"]= $ticketdetails['TagType'];
            $ticket["AvailableOn"]= $ticketdetails['AvailableOn'];
            $ticket["Status"]= $ticketdetails['Status'];
            $ticket["TicketType"]= $ticketdetails['TicketType'];
            $ticket["MappingId"]= $ticketdetails['MappingId'];
            $ticket["ItemCode"]= $ticketdetails['ItemCode'];
            $ticket["Category"]= $ticketdetails['Category'];
            $ticket["MaxSales"]= $ticketdetails['MaxSales'];
            $ticket["RemainingCapacity"]= $ticketdetails['RemainingCapacity'];
            $ticket["EventMaxCapacity"]= $ticketdetails['EventMaxCapacity'];
            $ticket["EventRemainingCapacity"]= $ticketdetails['EventRemainingCapacity'];
            $ticket["AccomodationRequirement"]= $ticketdetails['AccomodationRequirement'];
            $ticket["PackageContent"]= $ticketdetails['PackageContent'];
            $ticket["LedgerCode"]= $ticketdetails['LedgerCode'];
        
         array_push($eventDetails['tickets'],$ticket);
        }
    }
        
print_r($eventDetails);


// Close db connection
$conn->close();

?>
