<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\CourseController;
use App\Http\Controllers\CompetenciesController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', [HomeController::class,'index'])->middleware(['auth'])->name('dashboard');
//courses
Route::get('/course', [CourseController::class,'index'])->middleware(['auth'])->name('course');
Route::get('/addcourse', [CourseController::class, 'addcourse'])->name('addcourse');
Route::post('/newcourse', [CourseController::class, 'newcourse'])->name('newcourse');
Route::get('/editcourse/{id}', [CourseController::class, 'editCourse'])->name('editcourse');
Route::post('/updatecourse', [CourseController::class, 'updateCourse'])->name('updatecourse');
Route::get('/deletecourse/{id}', [CourseController::class, 'deletecourse'])->name('deletecourse');


//courses
Route::get('/competencies', [CompetenciesController::class,'index'])->middleware(['auth'])->name('competencies');
Route::get('/addCompetencies', [CompetenciesController::class, 'addCompetencies'])->name('addCompetencies');
Route::post('/newCompetencies', [CompetenciesController::class, 'newCompetencies'])->name('newCompetencies');
Route::get('/editCompetencies/{id}', [CompetenciesController::class, 'editCompetencies'])->name('editCompetencies');
Route::post('/updateCompetencies', [CompetenciesController::class, 'updateCompetencies'])->name('updateCompetencies');
Route::get('/deleteCompetencies/{id}', [CompetenciesController::class, 'deleteCompetencies'])->name('deleteCompetencies');


require __DIR__.'/auth.php';


